package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteAperturasDaoImpl;
import com.ejie.ab04b.dao.TramiteOS3DaoImpl;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteOS3DaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TramiteOS3CustomDaoImpl extends TramiteOS3DaoImpl implements
		TramiteOS3CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TRAMITE_095 IDTRAMITE095, t1.TIPO_TRAMITE_095 TIPOTRAMITE095, t1.TERRIT_OS3_095 TERRITOS3095, t1.ANO_OS3_095 ANOOS3095, t1.NUM_OS3_095 NUMOS3095, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTRAMITES_OS3 t1 ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ID_TRAMITE_095 IDTRAMITE095, t1.TIPO_TRAMITE_095 TIPOTRAMITE095, t1.TERRIT_OS3_095 TERRITOS3095, t1.ANO_OS3_095 ANOOS3095, t1.NUM_OS3_095 NUMOS3095,t1.PROCEEDING_ID_089 PROCEEDINGID089,  J.FECPRE_056 FECHAPRESENTACION056 FROM VTRAMITES_OS3 t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_OS3_095 = J.TERAPE_056 AND t1.ANO_OS3_095  = J.ANOAPE_056 AND t1.NUM_OS3_095   = J.NUMAPE_056  ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TramiteOS3> rwMap = new RowMapper<TramiteOS3>() {
		public TramiteOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteOS3 tram = new TramiteOS3(resultSet.getLong("IDTRAMITE095"),
					null, null);

			tram.setOs3(new OS3(resultSet.getString("TERRITOS3095"), resultSet
					.getString("ANOOS3095"), resultSet.getInt("NUMOS3095")));

			tram.setTipoTramite(new Tramite(
					resultSet.getLong("TIPOTRAMITE095"), resultSet
							.getString("PROCEDUREID089"), resultSet
							.getString("PROCEEDINGID089"), resultSet
							.getString("DESCRIPCIONES089"), resultSet
							.getString("DESCRIPCIONEU089")));

			return tram;
		}
	};

	private RowMapper<TramiteOS3> rwMapDoc = new RowMapper<TramiteOS3>() {
		public TramiteOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteOS3 tram = new TramiteOS3(resultSet.getLong("IDTRAMITE095"),
					null, null);

			OS3 os3 = new OS3();
			os3.setTeros3061(resultSet.getString("TERRITOS3095"));
			os3.setAnoos3061(resultSet.getString("ANOOS3095"));
			os3.setNumos3061(resultSet.getInt("NUMOS3095"));
			os3.setFecpre061(resultSet.getDate("FECHAPRESENTACION056"));
			tram.setOs3(os3);

			Tramite tramite = new Tramite();
			tramite.setProceedingId089(resultSet.getString("PROCEEDINGID089"));
			tram.setTipoTramite(tramite);

			return tram;
		}
	};

	/**
	 * Finds a single row in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  TramiteOS3
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @return the tramite OS 3
	 */
	@Transactional(readOnly = true)
	public TramiteOS3 vfind(TramiteOS3 tramiteOS3) {
		StringBuilder query = new StringBuilder(
				TramiteOS3CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TRAMITE_095 = ? ");

		List<TramiteOS3> tramiteOS3List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, tramiteOS3.getIdTramite095());
		return (TramiteOS3) DataAccessUtils.uniqueResult(tramiteOS3List);
	}

	/**
	 * Finds a single row in the TramiteOS3 table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os3
	 *            OS3
	 *  TramiteOS3
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os3 the os 3
	 * @return the tramite OS 3
	 */
	@Transactional(readOnly = true)
	public TramiteOS3 findLastTramiteByTipo(Long idTipoTramite, OS3 os3) {
		StringBuilder query = new StringBuilder(
				TramiteOS3CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TIPO_TRAMITE_095 = ? AND t1.TERRIT_OS3_095 = ? AND ANO_OS3_095 = ? AND NUM_OS3_095 = ? ");
		query.append(" ORDER BY t1.ID_TRAMITE_095 DESC ");

		List<TramiteOS3> tramiteOS3List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, idTipoTramite,
				os3.getTeros3061(), os3.getAnoos3061(), os3.getNumos3061());

		if (tramiteOS3List == null || tramiteOS3List.isEmpty()) {
			return null;
		}
		return tramiteOS3List.get(0);
	}

	/**
	 * Finds a list of rows in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteOS3>
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS3> vfindAll(TramiteOS3 tramiteOS3,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TramiteOS3CustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramiteOS3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS3>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the TramiteOS3 table.
	 * 
	 *  filterAb0492s00
	 *            TramiteOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  b
	 *            boolean
	 *  List<TramiteOS3>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param b the b
	 * @return the list
	 */
	public List<TramiteOS3> findAllImprimirDocsOS3Like(
			TramiteOS3 filterAb0492s00, JQGridRequestDto jqGridRequestDto,
			boolean b) {
		StringBuilder query = new StringBuilder(
				TramiteOS3CustomDaoImpl.QUERY_SELECT_2);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereDocumentoMap(filterAb0492s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS3>) this.getJdbcTemplate().query(
				query.toString(), this.rwMapDoc, params.toArray());
	}

	/**
	 * Finds number of rows in the TramiteOS3 table.
	 * 
	 *  tramiteOS3
	 *            TramiteOS3
	 *  b
	 *            boolean
	 *  List<TramiteOS3>
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @param b the b
	 * @return the long
	 */
	public Long findAllLikeImprimirDocsOS3Count(TramiteOS3 tramiteOS3, boolean b) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VTRAMITES_OS3 t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_OS3_095 = J.TERAPE_056 AND t1.ANO_OS3_095  = J.ANOAPE_056 AND t1.NUM_OS3_095   = J.NUMAPE_056 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereDocumentoMap(tramiteOS3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteOS3 entity
	 * 
	 *  tramiteOS3
	 *            TramiteOS3 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TramiteOS3 tramiteOS3) {

		StringBuilder where = new StringBuilder(
				TramiteOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteOS3 != null && tramiteOS3.getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_095 = ?");
			params.add(tramiteOS3.getIdTramite095());
		}
		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_095 = ?");
			params.add(tramiteOS3.getTipoTramite().getIdTramite089());
		}
		if (tramiteOS3 != null && tramiteOS3.getOs3() != null
				&& tramiteOS3.getOs3().getTeros3061() != null) {
			where.append(" AND t1.TERRIT_OS3_095 = ?");
			params.add(tramiteOS3.getOs3().getTeros3061());
		}
		if (tramiteOS3 != null && tramiteOS3.getOs3() != null
				&& tramiteOS3.getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANO_OS3_095 = ?");
			params.add(tramiteOS3.getOs3().getAnoos3061());
		}
		if (tramiteOS3 != null && tramiteOS3.getOs3() != null
				&& tramiteOS3.getOs3().getNumos3061() != null) {
			where.append(" AND t1.NUM_OS3_095 = ?");
			params.add(tramiteOS3.getOs3().getNumos3061());
		}

		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_095 = ?");
			params.add(tramiteOS3.getTipoTramite().getIdTramite089());
		}
		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getProcedureId089() != null) {
			where.append(" AND t1.PROCEDURE_ID_089 = ?");
			params.add(tramiteOS3.getTipoTramite().getProcedureId089());
		}
		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteOS3.getTipoTramite().getProceedingId089());
		}
		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getDescripcionEs089() != null) {
			where.append(" AND t1.DESCRIPCION_ES_089 = ?");
			params.add(tramiteOS3.getTipoTramite().getDescripcionEs089());
		}
		if (tramiteOS3 != null && tramiteOS3.getTipoTramite() != null
				&& tramiteOS3.getTipoTramite().getDescripcionEu089() != null) {
			where.append(" AND t1.DESCRIPCION_EU_089 = ?");
			params.add(tramiteOS3.getTipoTramite().getDescripcionEu089());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteOS3 entity
	 * 
	 *  tramiteOS3
	 *            TramiteOS3 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tramiteOs3 the tramite os 3
	 * @return the where documento map
	 */
	private Map<String, ?> getWhereDocumentoMap(TramiteOS3 tramiteOs3) {

		StringBuilder where = new StringBuilder(
				TramiteAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getTeros3061() != null) {
			where.append(" AND t1.TERRIT_OS3_095 = ?");
			params.add(tramiteOs3.getOs3().getTeros3061());
		}
		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANO_OS3_095 = ?");
			params.add(tramiteOs3.getOs3().getAnoos3061());
		}
		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getNumExpDesde() != null) {
			where.append(" AND t1.NUM_OS3_095 >= ? ");
			params.add(tramiteOs3.getOs3().getNumExpDesde());
		}

		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getNumExpHasta() != null) {
			where.append(" AND t1.NUM_OS3_095 <= ?");
			params.add(tramiteOs3.getOs3().getNumExpHasta());
		}

		if (tramiteOs3 != null && tramiteOs3.getTipoTramite() != null
				&& tramiteOs3.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteOs3.getTipoTramite().getProceedingId089());
		}

		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getFecpreDesde() != null) {
			where.append(" AND J.FECPRE_056 >= ? ");
			params.add(tramiteOs3.getOs3().getFecpreDesde());
		}

		if (tramiteOs3 != null && tramiteOs3.getOs3() != null
				&& tramiteOs3.getOs3().getFecpreHasta() != null) {
			where.append(" AND J.FECPRE_056 <= ?");
			params.add(tramiteOs3.getOs3().getFecpreHasta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
